/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;

public class ArmorHyperModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> HYPER = TConstruct.createKey((String)"hyper_armor");

    public ArmorHyperModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorHyperModifier::onUpdateApply);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(HYPER, false, null));
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        AttributeInstance attributeInstance;
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_() && living.f_19797_ % 10 == 0 && living.m_20142_() && (attributeInstance = living.m_21051_(Attributes.f_22279_)) != null) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int levels = (Integer)holder.get(HYPER, (Object)0);
                if (levels > 0) {
                    List mobs = living.m_9236_().m_45976_(LivingEntity.class, living.m_20191_().m_82377_(5.0 + (double)levels, 5.0 + (double)levels, 5.0 + (double)levels));
                    int sum = 0;
                    for (LivingEntity mob : mobs) {
                        if (!(mob instanceof Enemy)) continue;
                        ++sum;
                    }
                    if (sum > 0) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, Math.round((float)sum / 3.0f) - 1));
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 60, Math.round((float)sum / 3.0f) - 1));
                    }
                }
            });
        }
    }
}

